#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "attribute.h"
#include "namespace.h"
#include "utils.h"

NAMESPACE attributes;

int add_attribute(char *name, ATTRIBUTE *a)
{
if(attributes.names_free>=attributes.names_size+1)expand_namespace(&attributes);
attributes.data[attributes.names_free]=a;
attributes.names[attributes.names_free]=strdup(name);
a->attribute_handle=attributes.names_free;
attributes.names_free++;
return 0;
}

void init_attributes(void)
{
init_namespace(&attributes);
attributes.add_object=(int (*)(char *,void *))add_attribute;
}


ATTRIBUTE *add_new_attribute(char *name)
{
ATTRIBUTE *a;
a=do_alloc(1,sizeof(ATTRIBUTE));
add_attribute(name,a);
a->name=strdup(name);
a->type=-1;
return a;
}

void evolve_attributes(void)
{
long i;
ATTRIBUTE *a;
for(i=0;i<attributes.names_free;i++){
	a=(ATTRIBUTE *)attributes.data[i];
	switch(a->type){
		case TYPE_REPERTOIRE:
			evolve_repertoire(&(a->param.rep));
			break;
		default: 
			break;
		}
	}
}

char *type2name(long type)
{
switch(type){
	case TYPE_INT:  return "int";
	case TYPE_BOOL: return "bool";
	case TYPE_SET:  return "set";
	case TYPE_REPERTOIRE: return "repertoire";
	default:        return "abstract";
	}
}

void dump_attribute(FILE *fout, ATTRIBUTE *a)
{
fprintf(fout,"attribute \"%s\"\n",a->name);
fprintf(fout,"\ttype %s\n",type2name(a->type));
fprintf(fout,"\tdefault %lld\n",a->default_value);
switch(a->type){
	case TYPE_INT:
			fprintf(fout,"\tlargest %lld\n",a->param.integer.largest);
			fprintf(fout,"\tsmallest %lld\n",a->param.integer.smallest);
			break;
	case TYPE_SET:
			fprintf(fout,"\tsize %d\n",a->param.set.size);
			break;
	case TYPE_REPERTOIRE:
			dump_attr_rp(fout,&(a->param.rep));
			break;			
	default:
		break;
	}
fprintf(fout,"end\n");
}

void dump_attributes(FILE *fout)
{
long i;
for(i=0;i<attributes.names_free;i++)
	dump_attribute(fout,(ATTRIBUTE *)attributes.data[i]);
}

long num_attributes(void)
{
return attributes.names_free;
}

ATTRIBUTE *get_attribute(long i)
{
if(i<0)return NULL;
if(i>=attributes.names_free)return NULL;
return (ATTRIBUTE *)attributes.data[i];
}

long get_attribute_index(char *name)
{
long i;
for(i=0;i<attributes.names_free;i++){
	if(!strcmp(attributes.names[i],name))return i;
	}
return -1;
}


u64 generate_value(ATTRIBUTE *a,ATTRIBUTE_PARAM *ap)
{
long result,a1,b1;
if(!ap->random)return ap->value;
switch(a->type){
	case TYPE_INT:
		if(a->param.integer.smallest>ap->param.integer.smallest)
			a1=a->param.integer.smallest;
			else
			a1=ap->param.integer.smallest;
		if(a->param.integer.largest<ap->param.integer.largest)
			b1=a->param.integer.largest;
			else
			b1=ap->param.integer.largest;
		return make_random_int(a1,b1);
	case TYPE_BOOL:
		return make_random_bool();
	case TYPE_SET: 
		result=0;
		b1=ap->param.set.mask_random & 
			(~ap->param.set.mask_off) &
			(~ap->param.set.mask_on) &
			(~ ( (~0)<<a->param.set.size));
		for(a1=0;a1<64;a1++)
			if(ap->param.set.mask_random & (1<<a1)){
				result|=((make_random_bool()) << a1);
				}
		result|=ap->param.set.mask_on;
		result&=~(ap->param.set.mask_off);
		return result;
	case TYPE_REPERTOIRE:
		return make_repertoire(&(a->param.rep),&(ap->param.rep));
	default:
		return 0;
	}
}

void dump_param(FILE *fout, ATTRIBUTE *a,ATTRIBUTE_PARAM *ap)
{
int i;
fprintf(fout,"\tattribute \"%s\" %ld",a->name,a->type);
switch(a->type){
	case TYPE_REPERTOIRE:
		fprintf(fout," size(%d)",ap->param.rep.size);
		if(size(ap->param.rep.mask_random)>=a->param.rep.size)
			fprintf(fout," random(all)");
			else{
			fprintf(fout," random(");
			if(!size(ap->param.rep.mask_random))fprintf(fout,"empty");
				else for(i=0;i<a->param.set.size;i++)
					if(ap->param.rep.mask_random & (((u64)1)<<i))fprintf(fout,"%s%d",i==0 ? "" : ",",i);
			fprintf(fout,")");
			} 
		fprintf(fout,"\n");
		return;
	default:
		if(!ap->random){
			fprintf(fout," %lld\n",ap->value);
			return;
			}
		}
/* finish this later */
}		

char *get_attribute_name(long index)
{
ATTRIBUTE *a;

a=get_attribute(index);
if(a==NULL)return "attr_unknown";
return a->name;
}
